﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<Budros.Web.Models.Shared.MapViewModel>" %>

<!-- Embedded Google Map -->
<script type="text/javascript" src="http://maps.googleapis.com/maps/api/js?sensor=false"></script>
<div id="map-data"
    data-showlabels="<%=Model.ShowLabels %>"
    data-zoom="<%=Model.Zoom %>"
    data-xcenter="<%=Model.CenterPositionX %>"
    data-ycenter="<%=Model.CenterPositionY %>"
    data-opacity="<%=Model.MarkersOpacity %>">
</div>
<%if (Model.MapList != null)
  {
      foreach (var map in Model.MapList)
      {%>
<div class="map-item hidden"
    data-content="<%=map.Content %>"
    data-xposition="<%=map.PositionX %>"
    data-yposition="<%=map.PositionY %>">
</div>
<%}
  }%>
<div id="gmap_canvas"></div>

<style>
    #gmap_canvas {
        width: 100%;
        height: 100%;
    }

        #gmap_canvas img {
            max-width: none !important;
            background: none !important;
        }
</style>
<script src="<%=Url.Content("~/Scripts/App/Shared/map.js")%>"></script>
