﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/BudrosSite.Master" Inherits="System.Web.Mvc.ViewPage<Budros.Web.Models.Projects.ProjectDetailsViewModel>" %>

<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="HeadPlaceHolder">
    <%if (!String.IsNullOrEmpty(Model.Title))
      {%>
    <title><%=Model.Title %></title>
    <meta name="title" content="<%=Model.Title %>" />
    <%} %>
    <%if (Model.Characteristics != null && !String.IsNullOrEmpty(Model.Characteristics.Content))
      {%>
    <meta name="description" content="<%=Model.Characteristics.Content %>" />
    <%} %>
    <meta name="keywords" content="Mieszkania Gdańsk Budros" />

    <%if (Model.ProjectId==3) {%>
    <!-- Facebook Pixel Code -->
    <script>
        !function (f, b, e, v, n, t, s) {
            if (f.fbq) return; n = f.fbq = function () {
                n.callMethod ?
                n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            }; if (!f._fbq) f._fbq = n;
            n.push = n; n.loaded = !0; n.version = '2.0'; n.queue = []; t = b.createElement(e); t.async = !0;
            t.src = v; s = b.getElementsByTagName(e)[0]; s.parentNode.insertBefore(t, s)
        }(window,
        document, 'script', '//connect.facebook.net/en_US/fbevents.js');

        fbq('init', '264876887052414');
        fbq('track', "PageView");</script>
    <noscript><img height="1" width="1" 
style="display:none"
src="https://www.facebook.com/tr?id=264876887052414&ev=PageView&noscript=1"
/></noscript>
    <!-- End Facebook Pixel Code -->
    <%} %>
</asp:Content>

<asp:Content ID="StylesheetsPlaceholder" runat="server" ContentPlaceHolderID="StylesheetsPlaceholder">
    <link href="/Stylesheets/Projects/projects.css" rel="stylesheet" />
    <link href="/Stylesheets/Projects/projects-mobile.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/prettyphoto.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/nivoslider.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/Photogallery/photogallery.css" rel="stylesheet" />
</asp:Content>
<asp:Content ID="Content" runat="server" ContentPlaceHolderID="ContentPlaceholder">
    <div class="container">
        <%if (Model.HasSplashImage)
          { %>
        <div class="splash-image">
            <img alt="gallery-image" src="<%: Url.Action("GetSplashImage", "Projects", new { projectId = Model.ProjectId}) %>" />
        </div>
        <%} %>
        <div id="backgroundholder" class="hidden" data-background="<%=Model.RGBColor %>"></div>
        <div id="backgroundholdersecond" class="hidden" data-background="<%=Model.RGBColorSecond %>"></div>
        <div id="modelIdHolder" class="hidden" data-project="<%=Model.ProjectId %>"></div>
        <div class="col-md-3 noleftpadding mobile-norightpadding">
            <div class="col-md-12 logo-img mobile-norightpadding subheader-container">
                <div class="subheader js-border">
                    <img alt="gallery-image" src="<%: Url.Action("GetLogo", "Projects", new { projectId = Model.ProjectId}) %>" />
                </div>
            </div>
            <div class="col-md-12 noleftpadding mobile-norightpadding text-uppercase left-menu-container">
                <ul class="navigation nav nav-pills nav-stacked left-menu js-border">
                    <li class="active"><a data-toggle="tab" href="#characteristics" class="js-tab js-font menu-characteristics" data-subheader="<%=ViewResources.ProjectsStrings.Characteristics %>"><%=ViewResources.ProjectsStrings.Characteristics %></a></li>
                    <li id="mapTabMenu"><a id="mapTab" data-toggle="tab" href="#location" class="js-tab js-font menu-location" data-subheader="<%=ViewResources.ProjectsStrings.Location %>"><%=ViewResources.ProjectsStrings.Location %></a></li>
                    <li><a data-toggle="tab" href="#gallery" class="js-tab js-font menu-gallery" data-subheader="<%=ViewResources.ProjectsStrings.Gallery %>"><%=ViewResources.ProjectsStrings.Gallery %></a></li>
                    <li><a data-toggle="tab" href="#apartmentsTable" class="js-tab js-font menu-apartmentsTable" data-subheader="<%=ViewResources.ProjectsStrings.ApartmentsToSale %>"><%=ViewResources.ProjectsStrings.ApartmentsToSale %></a></li>
                    <%if (Model.HasApartmentsPlan)
                      { %>
                    <li><a data-toggle="tab" href="#apartments" class="js-tab js-font menu-apartments" data-subheader="<%=ViewResources.ProjectsStrings.Apartments %>"><%=ViewResources.ProjectsStrings.Apartments %></a></li>
                    <%} %>
                    <%if (Model.HasSetup)
                      { %>
                    <li><a data-toggle="tab" href="#setup" class="js-tab js-font menu-setup" data-subheader="<%=ViewResources.ProjectsStrings.Setup %>"><%=ViewResources.ProjectsStrings.Setup %></a></li>
                    <%} %>
                    <%if (Model.HasRestAndEarn)
                      { %>
                    <li><a data-toggle="tab" href="#restAndEarn" class="js-tab js-font menu-restAndEarn" data-subheader="<%=ViewResources.ProjectsStrings.RestAndEarn %>"><%=ViewResources.ProjectsStrings.RestAndEarn %></a></li>
                    <%} %>
                    <%if (Model.HasRestoreVat)
                      { %>
                    <li><a data-toggle="tab" href="#restoreVat" class="js-tab js-font menu-restoreVat" data-subheader="<%=ViewResources.ProjectsStrings.RestoreVat %>"><%=ViewResources.ProjectsStrings.RestoreVat %></a></li>
                    <%} %>
                    <%if (Model.HasMdm)
                      { %>
                    <li><a data-toggle="tab" href="#mdm" class="js-tab js-font menu-mdm" data-subheader="<%=ViewResources.ProjectsStrings.Mdm %>"><%=ViewResources.ProjectsStrings.Mdm %></a></li>
                    <%} %>
                    <%if (Model.HasCredits)
                      { %>
                    <li><a data-toggle="tab" href="#credits" class="js-tab js-font menu-credits" data-subheader="<%=ViewResources.ProjectsStrings.Credits %>"><%=ViewResources.ProjectsStrings.Credits %></a></li>
                    <%} %>
                </ul>
                <div class="nopadding office js-border js-font-second">
                    <%if (Model.Office != null)
                      { %>
                    <span class="line header-address">
                        <h5 class="text-uppercase bold"><%=Model.Office.Name%></h5>
                    </span>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Phone %>"><i class="fa fa-phone"></i></abbr>
                        <span class="tel"><%=Model.Office.Phone %></span>
                    </div>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Email %>"><i class="fa fa-envelope-o"></i></abbr>
                        <span class="tel"><a class="js-font-second text-lowercase" href="mailto:<%=Model.Office.Email %>"><%=Model.Office.Email %></a></span>
                    </div>
                    <%} %>
                </div>
            </div>
        </div>
        <div class="col-md-9 noleftpadding norightpadding ">
            <div class="tab-content text-justify">
                <div id="characteristics" class="tab-pane fade in active tab-entry">
                    <% if (Model.Characteristics != null)
                       {
                           Html.RenderPartial("ProjectCharacteristics", Model.Characteristics);
                       } %>
                </div>
                <div id="location" class="tab-pane fade tab-entry">
                    <% if (Model.Location != null)
                       {
                           Html.RenderPartial("ProjectLocation", Model.Location);
                       } %>
                </div>
                <div id="gallery" class="tab-pane fade tab-entry">
                    <% if (Model.Gallery != null)
                       {
                           Html.RenderPartial("ProjectGallery", Model.Gallery);
                       } %>
                </div>
                <div id="apartments" class="tab-pane fade tab-entry">
                    <% if (Model.ApartmentsPlan != null)
                       {
                           Html.RenderPartial("ApartmentsPlan", Model.ApartmentsPlan);
                       } %>
                </div>
                <div id="apartmentsTable" class="tab-pane fade tab-entry">
                    <% Html.RenderPartial("ApartmentsTable", Model.ProjectId);%>
                </div>
                <div id="credits" class="tab-pane fade tab-entry">
                    <% if (Model.Credits != null)
                       {
                           Html.RenderPartial("ProjectCredits", Model.Credits);
                       } %>
                </div>
                <div id="setup" class="tab-pane fade tab-entry">
                    <% if (Model.FinalSetup != null)
                       {
                           Html.RenderPartial("ProjectSetup", Model.FinalSetup);
                       } %>
                </div>
                <div id="restAndEarn" class="tab-pane fade tab-entry">
                    <% if (Model.RestAndEarn != null)
                       {
                           Html.RenderPartial("ProjectRestAndEarn", Model.RestAndEarn);
                       } %>
                </div>
                <div id="restoreVat" class="tab-pane fade tab-entry">
                    <% if (Model.RestoreVat != null)
                       {
                           Html.RenderPartial("ProjectRestoreVat", Model.RestoreVat);
                       } %>
                </div>
                <div id="mdm" class="tab-pane fade tab-entry">
                    <% if (Model.Mdm != null)
                       {
                           Html.RenderPartial("ProjectMdm", Model.Mdm);
                       } %>
                </div>
            </div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="ScriptsPlaceHolder" runat="server" ContentPlaceHolderID="ScriptsPlaceHolder">
    <script src="<%=Url.Content("~/Scripts/3rdParty/foundation.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.nivo.slider.pack.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.prettyPhoto.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/custom.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.isotope.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/modernizr-2.0.6.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Projects/apartmentsTable.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Projects/apartmentsPlan.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Shared/backgroundManager.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Shared/splash.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Projects/projectDetails.js")%>"></script>
</asp:Content>
