﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage" %>

<!DOCTYPE html>

<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="google" content="notranslate">
    <title>BUDROS - Edycja</title>
    <link href="/Stylesheets/Shared/bootstrap.min.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/modern-business.css" rel="stylesheet" />
    <link href="/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <link href="/Stylesheets/Edit/edit.css" rel="stylesheet" />
</head>
<body>
    <% Html.RenderPartial("ServerUrls"); %>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/bootstrap.min.js")%>"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.0.7/angular.min.js"></script>
    <script src="<%=Url.Content("~/Scripts/App/Editor/apartmentsTableEdit.js")%>"></script>

    <div ng-app="ApartmentsTableEdit">
        <div class="container" ng-controller="ApartmentsTableEditController">
            <div class="row">
                <div class="col-lg-1 pull-left">
                    <a href="/Home/Home">
                        <img style="height: 40px; width: 100px;" src="/Images/Shared/budros.jpg" />
                    </a>
                </div>
                <div class="col-lg-3">
                    <select class="form-control" ng-model="selectedItem" ng-options="item.ProjectId as item.Title for item in projects" ng-change="changeSelectedProject(selectedItem)">
                        <option value="">Wybierz projekt</option>
                    </select>
                </div>
                <div class="col-lg-2">
                    <button type="button" class="btn btn-primary" ng-click="loadApartments()" ng-disabled="loadApartmentsDisabled"><i class="glyphicon glyphicon-open-file"></i>&nbsp;Załaduj tabelę mieszkań</button>
                </div>
                <div class="col-lg-1" style="margin-left: 10px;">
                    <button id="save-button" type="button" class="btn btn-success hidden" ng-click="saveAll()"><i class="glyphicon glyphicon-floppy-disk"></i>&nbsp;Zapisz</button>
                </div>
                <div class="col-lg-1">
                    <div id="loading-icon" class='fa fa-spinner fa-spin fa-2x hidden'></div>
                </div>
                <div class="col-lg-2 pull-right">
                    <a href="<%: Url.Action("Logout", "Editor")%>">
                        <i class='glyphicon glyphicon-log-out'></i>&nbsp;Wyloguj
                    </a>
                </div>
            </div>
            <div class="row" ng-show="apartmentsList.length > 0" ng-model="apartmentsList">
                <strong>
                    <div class="row table-row header-row global-font text-uppercase mobile-font-default">
                        <div class="col-xs-2 col-lg-2 grid-header"><%=ViewResources.ProjectsStrings.Building %></div>
                        <div class="col-xs-2 col-lg-2 grid-header grid-header-right"><%=ViewResources.ProjectsStrings.Local%></div>
                        <div class="col-xs-2 col-lg-2 "><%=ViewResources.ProjectsStrings.RoomsCount %></div>
                        <div class="col-xs-2 col-lg-2 grid-header grid-header-right grid-header-left"><%=ViewResources.ProjectsStrings.Space %></div>
                        <div class="col-xs-2 col-lg-2 "><%=ViewResources.ProjectsStrings.Price %> m<sup>2</sup> (PLN)</div>
                        <div class="col-xs-2 col-lg-2 grid-header-left"><%=ViewResources.ProjectsStrings.Status %></div>
                        <%--<div class="col-xs-2 col-lg-2 grid-header-left"><%=ViewResources.ProjectsStrings.Plan %></div>--%>
                    </div>
                </strong>
            </div>
            <div class="row table-row" ng-repeat="item in apartmentsList">
                <div class="col-xs-2 col-md-2 apartment-col">{{ item.Building }}</div>
                <div class="col-xs-2 col-md-2 apartment-col">{{ item.Local }}</div>
                <div class="col-xs-2 col-md-2 apartment-col">{{ item.RoomsCount }}</div>
                <div class="col-xs-2 col-md-2 apartment-col">
                    <input class="form-control" ng-model="item.Space" />
                </div>
                <%--<div class="col-xs-2 col-md-2 apartment-col">{{ item.Price }}</div>--%>
                <div class="col-xs-2 col-md-2 apartment-col">
                    <select class="form-control" ng-model="item.IsAskForPriceSet" ng-options="element.Value as element.Name for element in priceOptions" ng-change="changePriceOption(item)" />
                    <input class="form-control" ng-model="item.Price" ng-disabled="item.IsAskForPriceSet" />
                </div>
                <div class="col-xs-2 col-md-2 apartment-col">
                    <select class="form-control" ng-model="item.Status" ng-options="element.Value as element.Name for element in statusOptions" />
                </div>
                <%--<div class="col-xs-2 col-md-2 apartment-col">{{ item.Local }}</div>--%>
            </div>
        </div>
    </div>
</body>
</html>

