﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/BudrosSite.Master" Inherits="System.Web.Mvc.ViewPage<Budros.Web.Models.Developed.DevelopedViewModel>" %>

<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="HeadPlaceHolder">
    <title>Lista najważniejszych zrealizowanych obiektów - Deweloper Budros | Mieszkania na sprzedaż | Gdańsk - Budros</title>
    <meta name="title" content="Realizacje" />
    <meta name="description" content="Przedstawiamy Państwu wybrane realizacje firmy Budros na terenie trójmiasta." />
    <meta name="keywords" content="Mieszkania Gdańsk Budros" />
</asp:Content>

<asp:Content ID="StylesheetsPlaceholder" runat="server" ContentPlaceHolderID="StylesheetsPlaceholder">
    <link href="../../Stylesheets/Shared/prettyphoto.css" rel="stylesheet" />
    <link href="../../Stylesheets/Shared/nivoslider.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/Photogallery/photogallery.css" rel="stylesheet" />
    <link href="/Stylesheets/Developed/developed.css" rel="stylesheet" />
    <link href="/Stylesheets/Developed/developed-mobile.css" rel="stylesheet" />
</asp:Content>


<asp:Content ID="Content" runat="server" ContentPlaceHolderID="ContentPlaceholder">
    <div class="container">
        <div id="backgroundholder" class="hidden" data-background="#a32727"></div>
        <div class="col-md-3 noleftpadding mobile-norightpadding">
            <div class="col-md-12 logo-img noleftpadding mobile-norightpadding subheader-container">
                <div class="subheader js-background" style="background-color: #a32727">
                    <span class="js-subheader text-uppercase">
                        <%if (Model.InitialActiveTab == 0)
                          {%>
                        <%=ViewResources.DevelopedStrings.RealizationsMap%>
                        <%}%>
                        <%if (Model.InitialActiveTab == 1)
                          {%>
                        <%=ViewResources.DevelopedStrings.RealizationsGallery%>
                        <%}%>
                    </span>
                </div>
            </div>
            <div class="col-md-12 noleftpadding mobile-norightpadding left-menu-container">
                <ul class="navigation nav nav-pills nav-stacked left-menu text-uppercase js-background" style="background-color: #a32727">
                    <%if (Model.InitialActiveTab == 0)
                      {%>
                    <li class="active">
                        <%}
                      else
                      {%>
                        <li>
                            <%}%>
                            <a id="mapTab" data-toggle="tab" href="#tab0" class="js-tab" data-subheader="<%=ViewResources.DevelopedStrings.RealizationsMap %>"><%=ViewResources.DevelopedStrings.RealizationsMap %></a></li>
                        <%if (Model.InitialActiveTab == 1)
                          {%>
                        <li class="active">
                            <%}
                          else
                          {%>
                            <li>
                                <%}%>
                                <a data-toggle="tab" href="#tab1" class="js-tab" data-subheader="<%=ViewResources.DevelopedStrings.RealizationsGallery%>"><%=ViewResources.DevelopedStrings.RealizationsGallery %></a></li>
                </ul>
                 <div class="nopadding office js-background" style="background-color: #a32727">
                    <%if (Model.Office != null)
                      { %>
                    <span class="line header-address">
                        <h5 class="text-uppercase bold"><%=Model.Office.Name%></h5>
                    </span>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Phone %>"><i class="fa fa-phone"></i></abbr>
                        <span class="tel"><%=Model.Office.Phone %></span>
                    </div>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Fax %>"><i class="fa fa-fax"></i></abbr>
                        <span class="tel"><%=Model.Office.Fax %></span>
                    </div>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Email %>"><i class="fa fa-envelope-o"></i></abbr>
                        <span class="tel"><a href="mailto:<%=Model.Office.Email %>"><%=Model.Office.Email %></a></span>
                    </div>
                    <%} %>
                </div>
            </div>
        </div>
        <div class="col-md-9 noleftpadding norightpadding">
            <div class="tab-content text-justify">
                <%if (Model.InitialActiveTab == 0)
                  {%>
                <div id="tab0" class="tab-pane fade in active">
                    <%}
                  else
                  {%>
                    <div id="tab0" class="tab-pane fade in">
                        <%}%>
                        <%if (Model.DevelopedMap != null)
                          {
                              Html.RenderPartial("DevelopedMap", Model.DevelopedMap);
                          }%>
                    </div>
                    <%if (Model.InitialActiveTab == 1)
                      {%>
                    <div id="tab1" class="tab-pane fade in active">
                        <%}
                      else
                      {%>
                        <div id="tab1" class="tab-pane fade in">
                            <%}%>
                            <%if (Model.DevelopedGallery != null)
                              {
                                  Html.RenderPartial("Modules/Gallery", Model.DevelopedGallery);
                              }%>
                        </div>
                    </div>
                </div>
            </div>
</asp:Content>
<asp:Content ID="ScriptsPlaceHolder" runat="server" ContentPlaceHolderID="ScriptsPlaceHolder">
    <script src="<%=Url.Content("~/Scripts/3rdParty/foundation.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.nivo.slider.pack.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.prettyPhoto.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/custom.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.isotope.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/bootstrap.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Shared/tabSwitch.js")%>"></script>
</asp:Content>