﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/BudrosSite.Master" Inherits="System.Web.Mvc.ViewPage<Budros.Web.Models.Contact.ContactViewModel>" %>

<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="HeadPlaceHolder">
    <title>Kontakt - Deweloper Budros | Mieszkania na sprzedaż | Gdańsk - Budros</title>
    <meta name="title" content="Kontakt" />
    <meta name="description" content="Mieszkania Budros kontakt" />
    <meta name="keywords" content="Mieszkania Budros Gdańsk kontakt" />
</asp:Content>

<asp:Content ID="StylesheetsPlaceholder" runat="server" ContentPlaceHolderID="StylesheetsPlaceholder">
    <link href="/Stylesheets/Contact/contact.css" rel="stylesheet" />
    <link href="/Stylesheets/Contact/contact-mobile.css" rel="stylesheet" />
</asp:Content>

<asp:Content ID="Content" runat="server" ContentPlaceHolderID="ContentPlaceholder">
    <div class="container">
        <div id="backgroundholder" class="hidden" data-background="#a32727"></div>
        <div class="col-md-3 noleftpadding mobile-norightpadding">
            <div class="col-md-12 logo-img noleftpadding mobile-norightpadding subheader-container">
                <div class="subheader js-background" style="background-color: #a32727">
                    <span class="js-subheader text-uppercase">
                        <%if (Model.InitialActiveTab == 0)
                          {%>
                        <%=ViewResources.ContactStrings.Location%>
                        <%}%>
                        <%if (Model.InitialActiveTab == 1)
                          {%>
                        <%=ViewResources.ContactStrings.Contact%>
                        <%}%>
                    </span>
                </div>
            </div>
            <div class="col-md-12 noleftpadding mobile-norightpadding left-menu-container">
                <ul class="navigation nav nav-pills nav-stacked left-menu text-uppercase js-background" style="background-color: #a32727">
                    <%if (Model.InitialActiveTab == 0)
                      {%>
                    <li class="active">
                        <%}
                      else
                      {%>
                        <li>
                            <%}%>
                            <a id="mapTab" data-toggle="tab" href="#tab0" class="js-tab" data-subheader="<%=ViewResources.ContactStrings.Location %>"><%=ViewResources.ContactStrings.Location %></a></li>
                        <%if (Model.InitialActiveTab == 1)
                          {%>
                        <li class="active">
                            <%}
                          else
                          {%>
                            <li>
                                <%}%>
                                <a data-toggle="tab" href="#tab1" class="js-tab" data-subheader="<%=ViewResources.ContactStrings.Contact%>"><%=ViewResources.ContactStrings.Contact %></a></li>
                </ul>
                <div class="nopadding office js-background" style="background-color: #a32727">
                    <%if (Model.Office != null)
                      { %>
                    <span class="line header-address">
                        <h5 class="text-uppercase bold"><%=Model.Office.Name%></h5>
                    </span>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Phone %>"><i class="fa fa-phone"></i></abbr>
                        <span class="tel"><%=Model.Office.Phone %></span>
                    </div>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Fax %>"><i class="fa fa-fax"></i></abbr>
                        <span class="tel"><%=Model.Office.Fax %></span>
                    </div>
                    <div class="line">
                        <abbr title="<%=ViewResources.ContactStrings.Email %>"><i class="fa fa-envelope-o"></i></abbr>
                        <span class="tel"><a style="color: white;" href="mailto:<%=Model.Office.Email %>"><%=Model.Office.Email %></a></span>
                    </div>
                    <%} %>
                </div>
            </div>
        </div>
        <div class="col-md-9 noleftpadding norightpadding">
            <div class="tab-content text-justify">
                <%if (Model.InitialActiveTab == 0)
                  {%>
                <div id="tab0" class="tab-pane fade in active">
                    <%}
                  else
                  {%>
                    <div id="tab0" class="tab-pane fade in">
                        <%}%>
                        <%if (Model.Location != null)
                          {
                              Html.RenderPartial("ContactLocation", Model.Location);
                          }%>
                    </div>
                    <%if (Model.InitialActiveTab == 1)
                      {%>
                    <div id="tab1" class="tab-pane tab-entry fade in active">
                        <%}
                      else
                      {%>
                        <div id="tab1" class="tab-pane tab-entry fade in">
                            <%}%>
                            <% if (Model.Departments.Header != null)
                               { %>
                            <div class="tab-entry-header">
                                <div class="tab-entry-header-content">
                                    <%=Model.Departments.Header %>
                                </div>
                            </div>
                            <% } %>
                            <%if (Model.Departments != null)
                              {
                                  foreach (var department in Model.Departments.Departments)
                                  {
                                      Html.RenderPartial("Department", department);
                                  }
                              } %>
                            <!-- Contact Form -->
                            <div class="row">
                                <div class="col-md-12">
                                    <h3><%=ViewResources.ContactStrings.SendMessage %></h3>
                                    <form name="sentMessage" id="contactForm" novalidate>
                                        <div class="control-group form-group">
                                            <div class="controls">
                                                <label><%=ViewResources.ContactStrings.SenderName %>:</label>
                                                <input type="text" class="form-control validate" id="name" required data-validation-required-message="<%=ViewResources.ContactStrings.SenderNameRequired %>." />
                                                <p class="help-block"></p>
                                            </div>
                                        </div>
                                        <div class="control-group form-group">
                                            <div class="controls">
                                                <label><%=ViewResources.ContactStrings.SenderEmail %>:</label>
                                                <input type="email" class="form-control validate" id="email" required data-validation-required-message="<%=ViewResources.ContactStrings.SenderEmailRequired %>." data-validation-email-message="<%=ViewResources.ContactStrings.SenderEmailInvalid %>." />
                                            </div>
                                        </div>
                                        <div class="control-group form-group">
                                            <div class="controls">
                                                <label><%=ViewResources.ContactStrings.Message %>:</label>
                                                <textarea rows="10" cols="100" class="form-control validate" id="message" required data-validation-required-message="<%=ViewResources.ContactStrings.MessageRequired %>." maxlength="999" style="resize: none"></textarea>
                                            </div>
                                        </div>
                                        <div class='fa fa-spinner fa-spin fa-2x loading-icon hidden'></div>
                                        <div id="success"></div>
                                        <!-- For success/fail messages -->
                                        <button id="submit-btn" type="submit" class="validate btn btn-primary"><%=ViewResources.ContactStrings.Send %></button>
                                    </form>
                                </div>
                                <div id="formMessages" class="row hidden" data-successmessage="<%=ViewResources.ContactStrings.MessageSendSuccess %>." data-errormessage="<%=ViewResources.ContactStrings.MessageSendError %>."></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
</asp:Content>


<%--<asp:Content ID="Content" runat="server" ContentPlaceHolderID="ContentPlaceholder">
    <!-- Page Content -->
    <div class="container">
        <div class="row modules-map">
            <div class="col-md-12 panel panel-default map-div">
                <%if (Model.Map != null)
                      Html.RenderPartial("Modules/Map", Model.Map); %>
            </div>
            <%if (Model.Departments != null)
              {
                  foreach (var department in Model.Departments)
                  {
                      Html.RenderPartial("Department", department);
                  }
              } %>
        </div>

        <!-- Contact Form -->
        <div class="row">
            <div class="col-md-8">
                <h3><%=ViewResources.ContactStrings.SendMessage %></h3>
                <form name="sentMessage" id="contactForm" novalidate>
                    <div class="control-group form-group">
                        <div class="controls">
                            <label><%=ViewResources.ContactStrings.SenderName %>:</label>
                            <input type="text" class="form-control validate" id="name" required data-validation-required-message="<%=ViewResources.ContactStrings.SenderNameRequired %>." />
                            <p class="help-block"></p>
                        </div>
                    </div>
                    <div class="control-group form-group">
                        <div class="controls">
                            <label><%=ViewResources.ContactStrings.SenderEmail %>:</label>
                            <input type="email" class="form-control validate" id="email" required data-validation-required-message="<%=ViewResources.ContactStrings.SenderEmailRequired %>." data-validation-Email-Message="<%=ViewResources.ContactStrings.SenderEmailInvalid %>." />
                        </div>
                    </div>
                    <div class="control-group form-group">
                        <div class="controls">
                            <label><%=ViewResources.ContactStrings.Message %>:</label>
                            <textarea rows="10" cols="100" class="form-control validate" id="message" required data-validation-required-message="<%=ViewResources.ContactStrings.MessageRequired %>." maxlength="999" style="resize: none"></textarea>
                        </div>
                    </div>
                    <div class='fa fa-spinner fa-spin fa-2x loading-icon hidden'></div>
                    <div id="success"></div>
                    <!-- For success/fail messages -->
                    <button id="submit-btn" type="submit" class="validate btn btn-primary"><%=ViewResources.ContactStrings.Send %></button>
                </form>
            </div>
            <div id="formMessages" class="row hidden" data-successmessage="<%=ViewResources.ContactStrings.MessageSendSuccess %>." data-errormessage="<%=ViewResources.ContactStrings.MessageSendError %>."></div>
        </div>
        <!-- /.row -->

        <hr />
    </div>
</asp:Content>--%>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="ScriptsPlaceHolder">
    <script src="<%=Url.Content("~/Scripts/App/Contact/contact_me.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Contact/jqBootstrapValidation.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Shared/tabSwitch.js")%>"></script>
</asp:Content>
