﻿var initApartmentsTable = function () {
    var that = this;
    var apartments = {};
    var grid = $('.js-table-container');
    var paginationPanel = $('.js-pagination-panel');
    var pagingCombobox = $('.pagination-combobox');
    var projectId = $('#modelIdHolder').data('project');
    var initIndex;
    var activePageNumber;
    var filterCombobox = $('.filter-combobox');

    var allApartments;
    var apartmentsDisplayList;

    var itemsPerPage = 10;

    var apartmentCardUrlBuilder = function (id, title) {
        return "/Home/PdfViewerForApartment?apartmentId=" + id + "&amp;title=" + title;
    };

    var displayListScope = function (apartmentsList) {
        initIndex = (activePageNumber - 1) * itemsPerPage;
        if (grid !== undefined && grid !== null) {
            $(".js-data-row").remove();
            for (var i = initIndex; i < itemsPerPage + initIndex; i++) {
                var value = apartmentsList[i];
                if (value !== undefined && value !== null) {
                    var logoImageUrl = $('#getLogoUrl').val();
                    var title = value.Building + "/" + value.Local;
                    var url = apartmentCardUrlBuilder(value.Id, title);
                    var viewStrings = $('#apartmentStrings');
                    var row = '<div class="row table-row  js-data-row">';
                    var cardUrl = '<a onClick="ga("send", "event", "button", "click", "ApartmentsTable", "Card");" href="' + url + '" class="plan-img-link" target="_blank">' +
                        '<span class="fa-stack fa-1x apartment-icon"><i class="fa fa-file-pdf-o"></i></span>' +
                        '<img alt="logo" class="plan-img" src="' + logoImageUrl + '" /></a></div>';
                    var status = viewStrings.data('apartmentfree');
                    if (value.Status === 1) {
                        status = viewStrings.data('apartmentsold');
                        row = '<div class="row table-row js-data-row" style="background-color: silver; opacity:0.7;">';
                        cardUrl = '<span class="fa-stack fa-1x apartment-icon"><i class="fa fa-file-pdf-o"></i></span>' +
                        '<img alt="logo" class="plan-img" src="' + logoImageUrl + '" /></div>';
                    }
                    if (value.Status === 2) {
                        status = viewStrings.data('apartmentreserved');
                    }
                    var condignation = parseInt(value.Floor) + 1;
                    grid.append(row +
                        '<div class="apartment-col">' + value.Building + '</div>' +
                        '<div class="apartment-col">' + value.Local + '</div>' +
                        '<div class="apartment-col">' + condignation + '</div>' +
                        '<div class="apartment-col">' + value.Space + '</div>' +
                        '<div class="apartment-col">' + value.Entresol + '</div>' +
                        '<div class="apartment-col">' + value.Price + '</div>' +
                        '<div class="apartment-col">' + status + '</div>' +
                        '<div class="apartment-col">' + cardUrl +
                        '</div>');
                }
            }
        }
    };

    var initPaginationPanel = function (apartmentsList, apartmentsCount) {

        if (paginationPanel === undefined || paginationPanel === null) {
            return;
        }

        $(".js-page-button").remove();

        var pagesCount = Math.ceil(apartmentsCount / itemsPerPage);
        for (var i = 1; i <= pagesCount; i++) {
            var pageButton = '<li class="page-button js-page-button portofoliobutton" data-page="' + i + '"><a class="page" href="#">' + i + '</a></li>';
            if (i === 1) {
                pageButton = '<li class="page-button js-page-button portofoliobutton selected" data-page="' + i + '"><a class="page" href="#">' + i + '</a></li>';
            }
            paginationPanel.append(pageButton);
        }

        $(".js-page-button").each(function (index, value) {
            $(this).on("click", function () {
                $(".js-page-button").each(function () {
                    $(this).removeClass('selected');
                });

                $(this).addClass('selected');
                activePageNumber = $(this).data('page');
                displayListScope(apartmentsDisplayList);
            });
        });

        pagingCombobox.on('change', function () {
            itemsPerPage = parseInt(this.value);
            displayListScope(apartmentsDisplayList);

            var apartmentsCount = apartmentsDisplayList.length;
            activePageNumber = 1;
            if (apartmentsCount > itemsPerPage) {
                initPaginationPanel(apartmentsDisplayList, apartmentsCount);
            }
        });
    };

    var initGrid = function (apartmentsList) {
        allApartments = apartmentsList;
        apartmentsDisplayList = apartmentsList;
        var apartmentsCount = apartmentsList.length;
        activePageNumber = 1;
        displayListScope(apartmentsList);
        if (apartmentsCount > itemsPerPage) {
            initPaginationPanel(apartmentsList, apartmentsCount);
        }
    };

    $.ajax({
        url: GLOBAL.URLS.PROJECTS.GET_PROJECT_APARTMENTS,
        type: "POST",
        data: JSON.stringify({
            projectId: projectId
        }),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
            if (data !== undefined && data.Apartments !== undefined && data.Apartments !== null && data.Apartments.length > 0) {
                initGrid(data.Apartments);
                initFilters(data.Apartments);
            }
        },
        error: function (req, status, error) {
            alert('Server Error. Could not fetch Apartments plan:' +
                'request: ' + req + '\n' +
                'status: ' + status + '\n' +
                'error: ' + error);
            apartments = null;
        }
    });

    var initFilters = function (apartmentsList) {

        if (filterCombobox === undefined || filterCombobox === null) {
            return;
        }

        filterCombobox.on('change', function () {
            var filteredApartments = [];
            var selectedOption = this.selectedIndex;
            var i;
            switch (selectedOption) {
                case 0:
                    filteredApartments = allApartments;
                    break;
                case 1:
                    for (i = 0; i < allApartments.length; ++i) {
                        if (!(allApartments[i].IsSold)) {
                            filteredApartments.push(allApartments[i]);
                        }
                    }
                    break;
                case 2:
                    for (i = 0; i < allApartments.length; ++i) {
                        if (allApartments[i].IsSold) {
                            filteredApartments.push(allApartments[i]);
                        }
                    }
                    break;
            }

            activePageNumber = 1;

            apartmentsDisplayList = filteredApartments;

            var apartmentsCount = apartmentsDisplayList.length;
            displayListScope(apartmentsDisplayList);

            if (apartmentsCount > itemsPerPage) {
                initPaginationPanel(apartmentsDisplayList, apartmentsCount);
            }
        });
    };
};

window.onload = initApartmentsTable();