﻿window.addEventListener("load", windowLoadHandler, false);

function windowLoadHandler() {
    canvasApp();
}

function canvasSupport() {
    return Modernizr.canvas;
}

function canvasApp() {
    if (!canvasSupport()) {
        return;
    }

    var theCanvas = document.getElementById("generalPlanCanvas");

    var screenWidth = $(window).width();

    var theCanvasWidth = $(theCanvas).width();
    var theCanvasHeight = $(theCanvas).height();

    if (screenWidth < 1000) {
        var canvasWidth = screenWidth - 30;//margines 2 x 15px
        var factor = 1.688;
        var canvasHeight = canvasWidth / 1.688;

        theCanvasWidth = canvasWidth;
        theCanvasHeight = canvasHeight;
    }

    theCanvas.width = theCanvasWidth;
    theCanvas.height = theCanvasHeight;
    theCanvas.style.width = theCanvas.width.toString() + "px";
    theCanvas.style.height = theCanvas.height.toString() + "px";

    $('.buildings-plan').width(canvasWidth);
    $('.buildings-plan').height(canvasHeight);

    $('.floor-plan').width(canvasWidth);
    $('.floor-plan').height(canvasHeight);

    var context = theCanvas.getContext("2d");
    var projectId = $('#modelIdHolder').data('project');

    var navigationPanel = $('.navigation-panel');

    var buildingPlanHeader = $('.js-building-plan-header');

    var shapes;
    var mouseX;
    var mouseY;
    var popup;
    var popupSpan;
    var popupImg;
    var viewStrings;
    var defaultOpacity = 0.7;
    var selectedOpacity = 0.1;
    var selectedIndex;
    var previousIndex;
    var mode = 0; // 0 - buildings, 1 - apartments
    var clearMousePosition;
    init();

    function init() {
        popup = $('.popup');
        popupSpan = $('.popup span');
        popupImg = $('.popup img');
        viewStrings = $('#viewStrings');
        shapes = [];
        clearMousePosition = false;
        initReturnLink();

        fetchBuildingsPlan(true);
    }

    function fetchBuildingsPlan(setMouseListeners) {
        $.ajax({
            url: GLOBAL.URLS.PROJECTS.GET_PROJECT_BUILDINGS_PLAN,
            type: "POST",
            data: JSON.stringify({
                projectId: projectId
            }),
            contentType: "application/json; charset=utf-8",
            success: function (data) {
                if (data !== undefined && data !== null &&
                    data.Shapes !== undefined && data.Shapes !== null) {
                    showBuildingsPlan();
                    makeShapes(data.Shapes);
                    clearScreen();
                    drawScreen();
                    mode = 0;
                    if (setMouseListeners) {
                        theCanvas.addEventListener("mousemove", mouseOverListener, false);
                        theCanvas.addEventListener("mousedown", mouseDownListener, false);
                    }
                }
            },
            error: function (req, status, error) {
                alert('Server Error. Could not fetch Apartments plan:' +
                    'request: ' + req + '\n' +
                    'status: ' + status + '\n' +
                    'error: ' + error);
            }
        });
    }

    function mouseOverListener(evt) {
        var i;
        var mousePosition = getMousePosition(evt);
        if (selectedIndex !== undefined) {
            previousIndex = selectedIndex;
        }

        var isMouseOver = false;
        var popupContent;

        if (clearMousePosition) {
            mousePosition = {
                x: 0,
                y: 0
            }
            clearMousePosition = false;
        }

        //find which shape was hover
        for (i = 0; i < shapes.length; i++) {
            if (isPointInPoly(shapes[i], mousePosition)) {

                popupContent = shapes[i].content;
                isMouseOver = true;
                selectedIndex = i;
                break;
            }
        }

        var content = popupContent;

        var mouseXabs = evt.pageX - $(theCanvas).offset().left;
        var mouseYabs = evt.pageY - $(theCanvas).offset().top;

        var yOffset = 20;
        var popupPosX = mouseXabs - popup.width() / 2;
        var popupPosY = mouseYabs - popup.height() - yOffset;

        if (isMouseOver) {
            if (previousIndex !== undefined && previousIndex !== selectedIndex && previousIndex >= 0) {
                shapes[previousIndex].opacity = defaultOpacity;
                redrawSelectedShape(previousIndex);
            }

            if (shapes[selectedIndex].status !== 1) {
                if (content === '') {
                    popupImg.removeClass('hidden');
                }
                else {
                    popupImg.addClass('hidden');
                }
                popupSpan.html(content);
                popup.css({ position: "absolute", top: popupPosY, left: popupPosX });
                popup.show();
                $("body").css("cursor", "pointer");
                shapes[selectedIndex].opacity = selectedOpacity;
                redrawSelectedShape(selectedIndex);
            }
            else {
                $("body").css("cursor", "default");
                popup.hide();
            }
        } else {
            $("body").css("cursor", "default");
            if (previousIndex !== undefined && previousIndex <= shapes.length - 1) {
                shapes[previousIndex].opacity = defaultOpacity;
                redrawSelectedShape(previousIndex);
            }
            popup.hide();
        }
    }

    function mouseDownListener(evt) {
        var i;
        var mousePosition = getMousePosition(evt);
        var clickedIndex;
        var isClicked = false;
        //find which shape was hover
        for (i = 0; i < shapes.length; i++) {
            if (isPointInPoly(shapes[i], mousePosition)) {

                isClicked = true;
                clickedIndex = i;
                break;
            }
        }

        if (isClicked) {
            switch (mode) {
                case 0:
                    var floorId = 0;
                    loadApartments(shapes[clickedIndex].id,
                        floorId,
                        shapes[clickedIndex].content,
                        shapes[clickedIndex].floorCount);
                    showApartmentsLegend();
                    break;
                case 1:
                    if (shapes[clickedIndex] !== undefined && shapes[clickedIndex].status !== 1) {
                        ga('send', 'event', 'button', 'click', 'ApartmentsPlan', 'Card');
                        var cardLink = apartmentCardUrlBuilder(shapes[clickedIndex].id, "Apartment card");
                        var win = window.open(cardLink, '_blank');
                        win.focus();
                        clearMousePosition = true;
                    }
                    break;
            }
        }
    }

    function makeShapes(ajaxShapes) {
        var tempR;
        var tempG;
        var tempB;
        var tempColor;
        var soldColor;
        var reservedColor;
        shapes = [];

        tempR = Math.floor(252);
        tempG = Math.floor(189);
        tempB = Math.floor(0);
        tempColor = "rgb(" + tempR + "," + tempG + "," + tempB + ")";

        tempR = Math.floor(139);
        tempG = Math.floor(0);
        tempB = Math.floor(0);
        soldColor = "rgb(" + tempR + "," + tempG + "," + tempB + ")";

        tempR = Math.floor(76);
        tempG = Math.floor(93);
        tempB = Math.floor(3);
        reservedColor = "rgb(" + tempR + "," + tempG + "," + tempB + ")";

        var i;
        for (i = 0; i < ajaxShapes.length; i++) {
            var shape = ajaxShapes[i];
            var points = [];

            if (shape.Points === undefined || shape.Points === null) {
                continue;
            }

            var floorCount;
            if (shape.FloorCount !== undefined && shape.FloorCount !== null) {
                floorCount = shape.FloorCount;
            }

            var xFactor = theCanvasWidth / 100;
            var yFactor = theCanvasHeight / 100;

            var point = {};
            var j;
            for (j = 0; j < shape.Points.length; j++) {
                point = {
                    x: shape.Points[j].X * xFactor,
                    y: shape.Points[j].Y * yFactor
                };
                points.push(point);
            }

            var color = tempColor;

            if (shape.Status !== undefined && shape.Status === 1) {
                color = soldColor;
            }

            if (shape.Status !== undefined && shape.Status === 2) {
                color = reservedColor;
            }

            tempShape = {
                startPoint: {
                    x: shape.StartPoint.X * xFactor,
                    y: shape.StartPoint.Y * yFactor
                },
                points: points,
                color: color,
                content: shape.Content,
                opacity: defaultOpacity,
                id: shape.Id,
                floorCount: floorCount,
                status: shape.Status
            };

            shapes.push(tempShape);
        }
    }

    function isPointInPoly(polygon, pt) {

        var poly = polygon.points;
        poly.push(polygon.startPoint);

        for (var c = false, i = -1, l = poly.length, j = l - 1; ++i < l; j = i)
            ((poly[i].y <= pt.y && pt.y < poly[j].y) || (poly[j].y <= pt.y && pt.y < poly[i].y))
            && (pt.x < (poly[j].x - poly[i].x) * (pt.y - poly[i].y) / (poly[j].y - poly[i].y) + poly[i].x)
            && (c = !c);
        return c;
    }

    function drawShapes() {

        var i;
        for (i = 0; i < shapes.length; i++) {
            context.globalAlpha = shapes[i].opacity;
            context.fillStyle = shapes[i].color;
            context.beginPath();

            context.moveTo(shapes[i].startPoint.x, shapes[i].startPoint.y);
            var j;
            for (j = 0; j < shapes[i].points.length; j++) {
                context.lineTo(shapes[i].points[j].x, shapes[i].points[j].y);
            }
            context.stroke();
            context.strokeStyle = "white";
            context.closePath();
            context.fill();
        }
    }

    function drawScreen() {
        drawShapes();
    }

    function clearScreen() {
        context.clearRect(0, 0, theCanvas.width, theCanvas.height);
    }

    function drawShape(index) {

        context.globalCompositeOperation = 'source-over';

        var shape = shapes[index];
        context.globalAlpha = shape.opacity;
        context.fillStyle = shape.color;
        context.beginPath();

        context.moveTo(shape.startPoint.x, shape.startPoint.y);
        var j;
        for (j = 0; j < shape.points.length; j++) {
            context.lineTo(shape.points[j].x, shape.points[j].y);
        }
        context.closePath();
        context.fill();
    }

    function clearShape(index) {
        var shape = shapes[index];

        context.globalCompositeOperation = 'destination-out';
        context.beginPath();

        context.moveTo(shape.startPoint.x, shape.startPoint.y);
        var j;
        for (j = 0; j < shape.points.length; j++) {
            context.lineTo(shape.points[j].x, shape.points[j].y);
        }
        context.closePath();
        context.fill();
    }

    function redrawSelectedShape(index) {
        clearShape(index);
        drawShape(index);
    }

    function showBuildingsPlan() {
        $('.buildings-plan').removeClass('hidden');
        $('.floor-plan').each(function (index, value) {
            $(this).addClass('hidden');
        });
    }

    function showFloorPlan(buildId, floorId) {
        $('.buildings-plan').addClass('hidden');
        $('.floor-plan').each(function (index, value) {
            $(this).addClass('hidden');
            var buildingId = $(this).data('buildingid');
            var floorLevel = $(this).data('level');
            if (buildingId !== undefined && buildingId === buildId &&
                floorLevel !== undefined && floorLevel === floorId) {
                $(this).removeClass('hidden');
            }
        });
    }

    function getMousePosition(evt) {
        var bRect = theCanvas.getBoundingClientRect();

        mouseX = (evt.clientX - bRect.left) * (theCanvas.width / bRect.width);
        mouseY = (evt.clientY - bRect.top) * (theCanvas.height / bRect.height);

        var mousePosition = {
            x: mouseX,
            y: mouseY
        }
        return mousePosition;
    };

    function apartmentCardUrlBuilder(id, title) {
        return "/Home/PdfViewerForApartment?apartmentId=" + id + "&title=" + title;
    };

    function loadApartments(buildingId, floorNumber, content, floorCount) {
        shapes = [];

        $.ajax({
            url: GLOBAL.URLS.PROJECTS.GET_PROJECT_APARTMENTS_PLAN,
            type: "POST",
            data: JSON.stringify({
                buildingId: buildingId,
                floorLevel: floorNumber
            }),
            contentType: "application/json; charset=utf-8",
            success: function (data) {
                if (data !== undefined && data !== null &&
                    data.Shapes !== undefined && data.Shapes !== null) {
                    showFloorPlan(buildingId, floorNumber);
                    initNavigationPanel(content, floorCount, floorNumber, buildingId, content);
                    mode = 1;
                    makeShapes(data.Shapes);
                    clearScreen();
                    drawScreen();
                }
            },
            error: function (req, status, error) {
                alert('Server Error. Could not fetch Apartments plan:' +
                    'request: ' + req + '\n' +
                    'status: ' + status + '\n' +
                    'error: ' + error);
            }
        });
    };

    function initNavigationPanel(content, floorCount, activeFloorNumber, buildingId, content) {
        navigationPanel.removeClass('hidden');
        $('.js-building-content').text(content);
        initFloorsPanel(floorCount, activeFloorNumber, buildingId, content);

        buildingPlanHeader.addClass('hidden');
    }

    var initFloorsPanel = function (floorCount, activeFloorNumber, buildingId, content) {
        var floorsPanel = $('.js-floor-list');

        if (floorsPanel === undefined || floorsPanel === null) {
            return;
        }

        $(".js-floor-button").remove();

        var floorsPanelWidth = floorsPanel.width();
        var floorButtonWidth = Math.floor(floorsPanelWidth / floorCount);

        for (var i = 0; i < floorCount; i++) {
            var floorNumber = i + 1;
            var floorName = viewStrings.data('floor') + ' ' + floorNumber;
            //if (i === 0) {
            //    floorName = viewStrings.data('basefloor');
            //}

            var backgroundHolder = $('#backgroundholder');
            var color = backgroundHolder.data('background');

            var floorButton = '<li class="floor-button js-floor-button " data-floor="' + i + '" style="width:' + floorButtonWidth + 'px;"><div class="text-uppercase js-font-second" style="color:' + color + ';">' + floorName + '</div></li>';
            if (i === activeFloorNumber) {
                floorButton = '<li class="floor-button js-floor-button  selected" data-page="' + i + '" style="width:' + floorButtonWidth + 'px;"><div class="text-uppercase js-font-second" style="color:' + color + ';">' + floorName + '</div></li>';
            }
            floorsPanel.append(floorButton);
        }

        $(".js-floor-button").each(function (index, value) {
            $(this).on("click", function () {
                if (!($(this).hasClass('selected'))) {
                    $(".js-floor-button").each(function () {
                        $(this).removeClass('selected');
                    });

                    var floorId = $(this).data('floor');

                    loadApartments(buildingId,
                            floorId,
                            content,
                            floorCount);

                    $(this).addClass('selected');
                }
            });
        });
    };

    function initReturnLink() {
        $('.js-show-buildings-plan-btn').on("click", function () {
            navigationPanel.addClass('hidden');
            shapes = [];
            fetchBuildingsPlan(false);
            hideAparmentsLegend();
            buildingPlanHeader.removeClass('hidden');
        });
    };

    function showApartmentsLegend() {
        $('.js-apartments-legend').removeClass('hidden');
    };

    function hideAparmentsLegend() {
        $('.js-apartments-legend').addClass('hidden');
    };
}