﻿var ApartmentsTableEdit = angular.module('ApartmentsTableEdit', []);

ApartmentsTableEdit.controller('ApartmentsTableEditController', function ($scope, $http) {

    $scope.selectedProject = null;
    $scope.loadApartmentsDisabled = true;
    $scope.apartmentsList = [];
    $scope.statusOptions = [];
    $scope.priceOptions = [];

    $scope.statusOptions.push({
        Name: 'Wolne',
        Value: 0
    });

    $scope.statusOptions.push({
        Name: 'Sprzedane',
        Value: 1
    });

    $scope.statusOptions.push({
        Name: 'Zarezerwowane',
        Value: 2
    });

    $scope.priceOptions.push({
        Name: 'Wprowadź wartość',
        Value: 0
    });

    $scope.priceOptions.push({
        Name: 'Ustaw: "ZAPYTAJ"',
        Value: 1
    });

    $scope.saveButton = document.getElementById("save-button");
    $scope.loadingIcon = document.getElementById("loading-icon");
    $scope.askForApartmentExpression = "<a style='color:black;' href='mailto:mieszkania@budros.pl'>ZAPYTAJ</a>";

    $scope.hasClass = function (ele, cls) {
        return !!ele.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));
    }

    $scope.addClass = function (ele, cls) {
        if (!$scope.hasClass(ele, cls)) ele.className += " " + cls;
    }

    $scope.removeClass = function (ele, cls) {
        if ($scope.hasClass(ele, cls)) {
            var reg = new RegExp('(\\s|^)' + cls + '(\\s|$)');
            ele.className = ele.className.replace(reg, ' ');
        }
    }

    $scope.showLoadingIcon = function () {
        if ($scope.loadingIcon !== undefined && $scope.loadingIcon !== null) {
            $scope.removeClass($scope.loadingIcon, "hidden");
        }
    }

    $scope.hideLoadingIcon = function () {
        if ($scope.loadingIcon !== undefined && $scope.loadingIcon !== null) {
            $scope.addClass($scope.loadingIcon, "hidden");
        }
    }

    $scope.init = function (projects) {
        $scope.projects = projects;
    };

    $scope.saveItem = function (item, callback) {
        $scope.showLoadingIcon();
        $http({
            method: 'POST',
            url: GLOBAL.URLS.PROJECTS.UPDATE_APARTMENT,
            params: {
                id: item.Id,
                status: item.Status,
                price: item.Price,
                setAskForApartmentExpression: item.IsAskForPriceSet,
                space: item.Space
            }

        }).success(function (result) {
            //$scope.$apply();

            if (callback) {
                callback(true);
            }
        }).error(function (data, status, headers, config) {
            if (callback) {
                callback(false);
            }
        });
    };

    $scope.saveAll = function () {
        var success = true;
        var counter = $scope.apartmentsList.length;
        angular.forEach($scope.apartmentsList, function (item) {
            $scope.saveItem(item, function (isSuccess) {
                success = success && isSuccess;
                counter = counter - 1;
                if (counter === 0) {
                    $scope.hideLoadingIcon();
                    if (success) {
                        alert('Lista mieszkań została zapisana pomyślnie.');
                    } else {
                        alert('Błąd serwera. Nie udało się zapisać listy mieszkań.');
                    }
                }
            });
        });
    };

    $scope.fetchProjects = function () {
        $http({
            method: 'POST',
            url: GLOBAL.URLS.PROJECTS.GET_PROJECTS,
        }).success(function (result) {
            if (result !== undefined && result !== null) {
                $scope.init(result);
            }
        }).error(function (data, status, headers, config) {
            alert('Błąd serwera! Nie udało się pobrać listy projektów\n:' +
                        'data: ' + data + '\n' +
                        'status: ' + status + '\n' +
                        'config: ' + config + '\n' +
                        'headers: ' + headers);
        });
    };

    $scope.changeSelectedProject = function (item) {
        $scope.selectedProject = item;
        if (item === undefined || item === null) {
            $scope.loadApartmentsDisabled = true;
        } else {
            $scope.loadApartmentsDisabled = false;
        }
    };

    $scope.loadApartments = function () {
        var selectedProjectId = $scope.selectedProject;
        $scope.showLoadingIcon();

        if (selectedProjectId !== undefined && selectedProjectId != null) {
            $http({
                method: 'POST',
                url: GLOBAL.URLS.PROJECTS.GET_PROJECT_APARTMENTS,
                params: { projectId: selectedProjectId }
            }).success(function (result) {
                if (result !== undefined && result !== null && result.Apartments !== undefined && result.Apartments !== null) {

                    for (var i = 0; i < result.Apartments.length; i++) {
                        result.Apartments[i].IsAskForPriceSet = 0;
                        if (result.Apartments[i].Price === $scope.askForApartmentExpression) {
                            result.Apartments[i].IsAskForPriceSet = 1;
                            result.Apartments[i].Price = "";
                        }
                    }

                    $scope.apartmentsList = result.Apartments;
                    if ($scope.saveButton !== undefined && $scope.saveButton !== null) {
                        $scope.removeClass($scope.saveButton, "hidden");
                    }
                }
                $scope.hideLoadingIcon();
            }).error(function (data, status, headers, config) {
                alert('Server Error. Could not fetch Projects:\n' +
                            'data: ' + data + '\n' +
                            'status: ' + status + '\n' +
                            'config: ' + config + '\n' +
                            'headers: ' + headers);
                $scope.hideLoadingIcon();
            });
        }
    };

    $scope.changePriceOption = function (item) {
        if (item.IsAskForPriceSet === 0) {
            item.Price = '1 000';
        }
        else {
            item.Price = "";
        }
    };

    $scope.fetchProjects();
});